/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.client.BargainScreenStaminaWheelRenderer;
import tictim.paraglider.client.DisableStaminaRender;
import tictim.paraglider.client.StaminaWheelRenderer;
import tictim.paraglider.network.BargainMsg;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.recipe.bargain.BargainPreview;
import tictim.paraglider.recipe.bargain.StatueBargain;
import tictim.paraglider.recipe.bargain.StatueBargainContainer;
import tictim.paraglider.utils.TooltipFactory;

public class StatueBargainScreen
extends ContainerScreen<StatueBargainContainer>
implements DisableStaminaRender {
    private static final ResourceLocation MERCHANT_GUI_TEXTURE = new ResourceLocation("textures/gui/container/villager2.png");
    private static final long ITEM_CYCLE_TIME = 1000L;
    private static final long DIALOG_FADEOUT_START = 1750L;
    private static final long DIALOG_FADEOUT_END = 2000L;
    private static final int SCROLL_BOX_THING_WIDTH = 97;
    private static final int SCROLL_BOX_THING_HEIGHT = 142;
    private final BargainButton[] buttons = new BargainButton[7];
    private int buttonIndexOffset;
    private boolean isDragging;
    private long createdTime;
    private long currentTickTimestamp;
    @Nullable
    private ITextComponent dialog;
    private long dialogTimestamp;
    private boolean dialogUpdated;
    private StaminaWheelRenderer staminaWheelRenderer;
    private static final int BUTTON_INPUT_X_OFFSET_START = 2;
    private static final int BUTTON_INPUT_X_OFFSET_END = 22;
    private static final int BUTTON_OUTPUT_X_OFFSET_START = 50;
    private static final int BUTTON_OUTPUT_X_OFFSET_END = 70;

    public StatueBargainScreen(StatueBargainContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    protected void func_231160_c_() {
        this.field_146999_f = this.field_230708_k_;
        this.field_147000_g = this.field_230709_l_;
        this.currentTickTimestamp = this.createdTime = System.currentTimeMillis();
        PlayerMovement m = PlayerMovement.of((ICapabilityProvider)this.field_230706_i_.field_71439_g);
        this.staminaWheelRenderer = new BargainScreenStaminaWheelRenderer(m == null ? 0 : m.getMaxStamina());
        super.func_231160_c_();
        int y = this.getTop() + 1;
        for (int i = 0; i < 7; ++i) {
            this.buttons[i] = (BargainButton)this.func_230480_a_((Widget)new BargainButton(31, y + 20 * i, i, b -> {
                if (!(b instanceof BargainButton)) {
                    return;
                }
                BargainButton button = (BargainButton)b;
                StatueBargain bargain = button.getBargain();
                if (bargain != null) {
                    ModNet.NET.sendToServer((Object)new BargainMsg(bargain.func_199560_c()));
                }
            }));
        }
    }

    public int getLeft() {
        return 30;
    }

    public int getTop() {
        return (this.field_230709_l_ - 142) / 2;
    }

    public int getBottom() {
        return this.getTop() + 142;
    }

    public void setDialog(@Nullable ITextComponent dialog) {
        this.dialog = dialog;
        this.dialogUpdated = dialog != null;
    }

    private void renderScroller(MatrixStack matrixStack, int left, int top) {
        int yOffset;
        int offScreenBargains = ((StatueBargainContainer)this.field_147002_h).getBargains().size() + 1 - 7;
        if (offScreenBargains > 1) {
            int j = 139 - (27 + (offScreenBargains - 1) * 139 / offScreenBargains);
            int k = 1 + j / offScreenBargains + 139 / offScreenBargains;
            yOffset = Math.min(113, this.buttonIndexOffset * k);
            if (this.buttonIndexOffset == offScreenBargains - 1) {
                yOffset = 113;
            }
        } else {
            yOffset = 0;
        }
        StatueBargainScreen.func_238464_a_((MatrixStack)matrixStack, (int)(left + 90), (int)(top + 1 + yOffset), (int)this.func_230927_p_(), (float)0.0f, (float)199.0f, (int)6, (int)27, (int)256, (int)512);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        long newTimestamp = System.currentTimeMillis();
        if (StatueBargainScreen.func_231173_s_()) {
            this.createdTime += newTimestamp - this.currentTickTimestamp;
        }
        this.currentTickTimestamp = newTimestamp;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        List<StatueBargain> bargains = ((StatueBargainContainer)this.field_147002_h).getBargains();
        if (!bargains.isEmpty()) {
            RenderSystem.pushMatrix();
            RenderSystem.enableRescaleNormal();
            this.field_230706_i_.func_110434_K().func_110577_a(MERCHANT_GUI_TEXTURE);
            this.renderScroller(matrixStack, this.getLeft(), this.getTop());
            this.field_230707_j_.field_77023_b = 100.0f;
            for (BargainButton button : this.buttons) {
                button.renderItems(matrixStack);
            }
            this.field_230707_j_.field_77023_b = 0.0f;
            for (BargainButton button : this.buttons) {
                if (button.func_230449_g_()) {
                    this.renderPreview(matrixStack, button.getActualIndex());
                }
                button.func_230443_a_(matrixStack, mouseX, mouseY);
                button.field_230694_p_ = button.index < ((StatueBargainContainer)this.field_147002_h).getBargains().size();
            }
            RenderSystem.popMatrix();
            RenderSystem.enableDepthTest();
        }
        if (this.dialog != null) {
            long t;
            int alpha;
            if (this.dialogUpdated) {
                this.dialogTimestamp = this.currentTickTimestamp;
                this.dialogUpdated = false;
            }
            if ((alpha = (t = this.currentTickTimestamp - this.dialogTimestamp) >= 2000L ? 0 : (t <= 1750L ? 255 : MathHelper.func_76125_a((int)((int)((2000L - t) * 255L / 250L)), (int)0, (int)255))) > 4) {
                StatueBargainScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.dialog, (int)(this.field_230708_k_ / 2), (int)(this.getBottom() + 9), (int)(alpha << 24 | 0xFFFFFF));
            }
        }
        this.staminaWheelRenderer.renderStamina(matrixStack, this.getLeft() + 97 + 5, this.getTop() - 5 - 10, 0.0);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        this.lookAtStatue(partialTicks);
    }

    private void renderPreview(MatrixStack matrixStack, int bargainIndex) {
        int textMag;
        StatueBargainContainer.ItemDemand[] demands = ((StatueBargainContainer)this.field_147002_h).getDemandPreview(bargainIndex);
        if (demands.length == 0) {
            return;
        }
        int mag = demands.length <= 2 ? 8 : (demands.length <= 8 ? 4 : 2);
        int n = textMag = demands.length <= 8 ? 2 : 1;
        int rows = demands.length <= 2 ? 2 : (demands.length <= 8 ? 4 : 8);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 200.0);
        int left = this.getLeft() + 97 + 20;
        int top = this.getTop();
        for (int i = 0; i < demands.length; ++i) {
            StatueBargainContainer.ItemDemand demand = demands[i];
            ItemStack stack = this.cycle(demand.getPreviewItems());
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(left + i % rows * (16 * mag)), (double)(top + i / rows * (16 * mag)), (double)0.0);
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)mag, (double)mag, (double)1.0);
            this.field_230707_j_.func_239390_c_(stack, 0, 0);
            this.field_230707_j_.func_180453_a(this.field_230712_o_, stack, 0, 0, "");
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(15 * mag + 2 * textMag), (double)(16 * mag - 7 * textMag), (double)0.0);
            RenderSystem.scaled((double)textMag, (double)textMag, (double)1.0);
            String s = (demand.getCount() >= demand.getQuantity() ? Integer.valueOf(demand.getCount()) : TextFormatting.RED + "" + demand.getCount() + TextFormatting.RESET) + "/" + demand.getQuantity();
            StatueBargainScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)s, (int)(-this.field_230712_o_.func_78256_a(s)), (int)0, (int)-1);
            RenderSystem.popMatrix();
            RenderSystem.popMatrix();
        }
        matrixStack.func_227865_b_();
    }

    private void lookAtStatue(float partialTicks) {
        Vector3d lookAt = ((StatueBargainContainer)this.field_147002_h).getLookAt();
        if (lookAt == null) {
            return;
        }
        PlayerEntity player = this.field_213127_e.field_70458_d;
        Vector3d eyePosition = player.func_174824_e(partialTicks);
        double lookX = lookAt.func_82615_a() - eyePosition.field_72450_a;
        double lookY = lookAt.func_82617_b() - eyePosition.field_72448_b;
        double lookZ = lookAt.func_82616_c() - eyePosition.field_72449_c;
        double xzLength = MathHelper.func_76133_a((double)(lookX * lookX + lookZ * lookZ));
        double rotationPitch = MathHelper.func_76142_g((float)((float)(-MathHelper.func_181159_b((double)lookY, (double)xzLength) * 57.29577951308232)));
        double rotationYaw = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)lookZ, (double)lookX) * 57.29577951308232) - 90.0f));
        double lerpPercentage = (double)partialTicks * 0.3;
        player.field_70125_A = StatueBargainScreen.lerpAngle(lerpPercentage, MathHelper.func_76142_g((float)player.field_70125_A), rotationPitch);
        player.field_70177_z = StatueBargainScreen.lerpAngle(lerpPercentage, MathHelper.func_76142_g((float)player.field_70177_z), rotationYaw);
        player.func_70034_d(player.field_70177_z);
        player.field_70127_C = player.field_70125_A;
        player.field_70126_B = player.field_70177_z;
        player.field_70758_at = player.field_70759_as;
        player.field_70760_ar = player.field_70761_aq = player.field_70759_as;
    }

    private static float lerpAngle(double percentage, double start, double end) {
        return (float)MathHelper.func_219803_d((double)percentage, (double)(start < end ? (end - start > 180.0 ? start + 360.0 : start) : (start - end > 180.0 ? start - 360.0 : start)), (double)end);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(MERCHANT_GUI_TEXTURE);
        StatueBargainScreen.func_238464_a_((MatrixStack)matrixStack, (int)this.getLeft(), (int)this.getTop(), (int)this.func_230927_p_(), (float)4.0f, (float)17.0f, (int)97, (int)142, (int)256, (int)512);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        int bargainSize = ((StatueBargainContainer)this.field_147002_h).getBargains().size();
        if (bargainSize > 7) {
            this.buttonIndexOffset = MathHelper.func_76125_a((int)((int)((double)this.buttonIndexOffset - delta)), (int)0, (int)(bargainSize - 7));
        }
        return true;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDragging) {
            return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        int offScreenBargains = ((StatueBargainContainer)this.field_147002_h).getBargains().size() - 7;
        this.buttonIndexOffset = MathHelper.func_76125_a((int)((int)((mouseY - (double)this.getTop() + 1.0 - 13.5) / 112.0 * (double)offScreenBargains + 0.5)), (int)0, (int)offScreenBargains);
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        int left = this.getLeft();
        int top = this.getTop();
        if (((StatueBargainContainer)this.field_147002_h).getBargains().size() > 7 && mouseX > (double)(left + 90) && mouseX < (double)(left + 90 + 6) && mouseY > (double)(top + 1) && mouseY <= (double)(top + 1 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_238651_a_(MatrixStack matrixStack, int vOffset) {
        if (this.field_230706_i_.field_71441_e != null) {
            this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x70101010, -1609560048);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, matrixStack));
        } else {
            this.func_231165_f_(vOffset);
        }
    }

    private ItemStack cycle(ItemStack[] stacks) {
        if (stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        return stacks[(int)(Math.abs(this.currentTickTimestamp - this.createdTime) / 1000L % (long)stacks.length)];
    }

    private static int determinePosition(int n, int length, int start, int end) {
        if (n >= length) {
            throw new IllegalArgumentException("length");
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start");
        }
        if (length == 1) {
            return (start + end) / 2;
        }
        int span = end - start;
        int spanPerElement = Math.min(16, span / (length - 1));
        if (spanPerElement == 0) {
            return start - (length - 1 - span) / 2 + n;
        }
        int leftover = span % spanPerElement;
        return start + leftover / 2 + spanPerElement * n;
    }

    private final class BargainButton
    extends Button {
        private final int index;

        public BargainButton(int x, int y, int index, Button.IPressable pressedAction) {
            super(x, y, 89, 20, StringTextComponent.field_240750_d_, pressedAction);
            this.index = index;
            this.field_230694_p_ = false;
        }

        public int getIndex() {
            return this.index;
        }

        public int getActualIndex() {
            return this.index + StatueBargainScreen.this.buttonIndexOffset;
        }

        @Nullable
        public StatueBargain getBargain() {
            return ((StatueBargainContainer)StatueBargainScreen.this.field_147002_h).getBargain(this.getActualIndex());
        }

        protected int func_230989_a_(boolean isHovered) {
            return !((StatueBargainContainer)StatueBargainScreen.this.field_147002_h).canBargain(this.getActualIndex()) ? 0 : (isHovered ? 2 : 1);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public void renderItems(MatrixStack matrixStack) {
            int itemX;
            ItemStack stack;
            if (!this.field_230694_p_) {
                return;
            }
            StatueBargain bargain = this.getBargain();
            if (bargain == null) {
                return;
            }
            BargainPreview preview = bargain.getPreview();
            int buttonElementTop = this.field_230691_m_ + 2;
            List<BargainPreview.Demand> demands = preview.getDemands();
            for (int i = demands.size() - 1; i >= 0; --i) {
                BargainPreview.Demand demand = demands.get(i);
                ItemStack[] stacks = demand.getPreviewItems();
                if (stacks.length == 0) {
                    ParagliderMod.LOGGER.warn("Some of ItemDemandPreview has empty array of items.");
                    continue;
                }
                stack = StatueBargainScreen.this.cycle(stacks);
                if (stack.func_190926_b()) {
                    ParagliderMod.LOGGER.warn("Some of ItemDemandPreview has empty items.");
                    continue;
                }
                itemX = this.field_230690_l_ + StatueBargainScreen.determinePosition(i, demands.size(), 2, 22);
                StatueBargainScreen.this.field_230707_j_.func_239390_c_(stack, itemX, buttonElementTop);
                if (demand.getQuantity() == 1) continue;
                StatueBargainScreen.this.field_230707_j_.func_180453_a(StatueBargainScreen.this.field_230712_o_, stack, itemX, buttonElementTop, String.valueOf(demand.getQuantity()));
            }
            this.renderButtonArrows(matrixStack);
            List<BargainPreview.Offer> offers = preview.getOffers();
            for (int i = offers.size() - 1; i >= 0; --i) {
                BargainPreview.Offer offer = offers.get(i);
                stack = offer.getPreview();
                if (stack.func_190926_b()) {
                    ParagliderMod.LOGGER.warn("Some of ItemOfferPreview has empty item.");
                    continue;
                }
                itemX = this.field_230690_l_ + StatueBargainScreen.determinePosition(i, offers.size(), 50, 70);
                StatueBargainScreen.this.field_230707_j_.func_239390_c_(stack, itemX, buttonElementTop);
                if (offer.getQuantity() == 1) continue;
                StatueBargainScreen.this.field_230707_j_.func_180453_a(StatueBargainScreen.this.field_230712_o_, stack, itemX, buttonElementTop, String.valueOf(offer.getQuantity()));
            }
        }

        private void renderButtonArrows(MatrixStack matrixStack) {
            RenderSystem.enableBlend();
            StatueBargainScreen.this.field_230706_i_.func_110434_K().func_110577_a(MERCHANT_GUI_TEXTURE);
            BargainButton.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 39), (int)(this.field_230691_m_ + 5), (int)this.func_230927_p_(), (float)(((StatueBargainContainer)StatueBargainScreen.this.field_147002_h).canBargain(this.getActualIndex()) ? 15.0f : 25.0f), (float)171.0f, (int)10, (int)9, (int)256, (int)512);
        }

        public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (!this.field_230692_n_) {
                return;
            }
            StatueBargain bargain = this.getBargain();
            if (bargain == null) {
                return;
            }
            BargainPreview preview = bargain.getPreview();
            List<BargainPreview.Demand> demands = preview.getDemands();
            BargainPreview.Demand closestDemand = null;
            int closestDemandDistance = Integer.MAX_VALUE;
            for (int i = 0; i < demands.size(); ++i) {
                int itemX = this.field_230690_l_ + StatueBargainScreen.determinePosition(i, demands.size(), 2, 22);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestDemandDistance <= dist) break;
                closestDemandDistance = dist;
                closestDemand = demands.get(i);
            }
            if (closestDemand != null) {
                TooltipFactory tf = closestDemand.getTooltipFactory();
                if (tf != null) {
                    StatueBargainScreen.this.func_243308_b(matrixStack, tf.getTooltip(), mouseX, mouseY);
                } else {
                    StatueBargainScreen.this.func_230457_a_(matrixStack, StatueBargainScreen.this.cycle(closestDemand.getPreviewItems()), mouseX, mouseY);
                }
                return;
            }
            List<BargainPreview.Offer> offers = preview.getOffers();
            BargainPreview.Offer closestOffer = null;
            int closestOfferDistance = Integer.MAX_VALUE;
            for (int i = 0; i < offers.size(); ++i) {
                int itemX = this.field_230690_l_ + StatueBargainScreen.determinePosition(i, offers.size(), 50, 70);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestOfferDistance <= dist) break;
                closestOfferDistance = dist;
                closestOffer = offers.get(i);
            }
            if (closestOffer != null) {
                TooltipFactory tf = closestOffer.getTooltipFactory();
                if (tf != null) {
                    StatueBargainScreen.this.func_243308_b(matrixStack, tf.getTooltip(), mouseX, mouseY);
                } else {
                    StatueBargainScreen.this.func_230457_a_(matrixStack, closestOffer.getPreview(), mouseX, mouseY);
                }
            }
        }
    }
}

